import { _decorator, Component, Node, view, Sprite, UITransform, ProgressBar, assetManager, Label, director } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Script_Start')
export class Script_Start extends Component {
    start() {
        this.init();
    }

    init() {
        let viewWidth = view.getVisibleSize().width;
        let viewHeight = view.getVisibleSize().height;
        let viewAspect = viewWidth / viewHeight;

        let background = this.node.getChildByName('Background');
        let bgAspect = background.getComponent(Sprite).spriteFrame.width / background.getComponent(Sprite).spriteFrame.height;

        if (viewAspect >= bgAspect) {
            background.getComponent(UITransform).setContentSize(viewWidth, viewWidth / bgAspect);
        } else {
            background.getComponent(UITransform).setContentSize(viewHeight * bgAspect, viewHeight);
        }

        let ratio = this.node.getChildByName('Ratio');

        let progressBar = this.node.getChildByName('ProgressBar');
        progressBar.getComponent(ProgressBar).totalLength = progressBar.getComponent(UITransform).contentSize.width;

        let bar = progressBar.getChildByName('Bar');
        bar.setPosition(0, progressBar.getComponent(ProgressBar).totalLength / -2, 0);

        assetManager.loadBundle('behind', (err, bundle) => {
            if (err) {
                console.log(err);
            } else {
                bundle.preloadScene('Scene Home', (completedCount, totalCount) => {
                    progressBar.getComponent(ProgressBar).progress = completedCount / totalCount;
                    ratio.getComponent(Label).string = (completedCount / totalCount * 100).toFixed(1).toString() + '%';
                }, () => {
                    bundle.preloadScene('Scene Game');
                    director.loadScene('Scene Home');
                });
            }
        });
    }

    update(deltaTime: number) {

    }
}


